#include "stm32f1xx_hal.h"
#include "lsm6ds3.h"
//--------------------------------------------
//extern I2C_HandleTypeDef hi2c1;
extern	SPI_HandleTypeDef hspi2;
uint8_t buf2[14]={0};
char str1[30]={0};
//--------------------------------------------
void Error(void)
{
	LED_OFF;
}
//--------------------------------------------
uint8_t Accel_IO_Read(uint8_t RegisterAddr)
{
	return SPI2_read(RegisterAddr);
}
//--------------------------------------------
void Accel_IO_Write(uint8_t RegisterAddr, uint8_t Value)
{
	SPI2_write(RegisterAddr, Value);
}
//--------------------------------------------
void Accel_GetXYZ(int16_t* pData)
{
	uint8_t buffer[6];
	uint8_t i=0;
	buffer[0]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTX_L_XL);
	buffer[1]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTX_H_XL);
	buffer[2]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTY_L_XL);
	buffer[3]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTY_H_XL);
	buffer[4]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTZ_L_XL);
	buffer[5]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTZ_H_XL);
	for(i=0;i<3;i++)
	{
		pData[i] = ((int16_t)((uint16_t)buffer[2*i+1]<<8)+buffer[2*i]);
	}
}
//--------------------------------------------
void Gyro_GetXYZ(int16_t* pData)
{
	uint8_t buffer[6];
	uint8_t i=0;
	buffer[0]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTX_L_G);
	buffer[1]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTX_H_G);
	buffer[2]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTY_L_G);
	buffer[3]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTY_H_G);
	buffer[4]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTZ_L_G);
	buffer[5]=Accel_IO_Read(LSM6DS3_ACC_GYRO_OUTZ_H_G);
	for(i=0;i<3;i++)
	{
		pData[i] = ((int16_t)((uint16_t)buffer[2*i+1]<<8)+buffer[2*i]);
	}
}
//--------------------------------------------
uint8_t Accel_ReadID(void)
{
	uint8_t ctrl = 0x00;
	ctrl = Accel_IO_Read(0x0F);
	return ctrl;
}
//--------------------------------------------
void AccelGyro_Read(void)
{
	int16_t buffer[3] = {0};
	int16_t xval, yval, zval;
	Gyro_GetXYZ(buffer);
	xval=buffer[0]-88;
	if(xval<-32768) xval=-32768;
	yval=buffer[1]+325;
	if(yval>32767) yval=32767;
	zval=buffer[2]+135;
	if(zval>32767) zval=32767;
//	sprintf(str1,"X:%06d Y:%06d Z:%06d\r\n", xval, yval, zval);
//	HAL_UART_Transmit_DMA(&huart2, (uint8_t*)str1,strlen(str1));
	yval=-yval;
	buf2[0]=0x11;
	buf2[1]=0x55;
	buf2[2]=(uint8_t)(yval>>8);
	buf2[3]=(uint8_t)yval;
	buf2[4]=(uint8_t)(xval>>8);
	buf2[5]=(uint8_t)xval;
	buf2[6]=(uint8_t)(zval>>8);
	buf2[7]=(uint8_t)zval;
	//HAL_UART_Transmit_DMA(&huart2,buf2,8);
	
	if(zval>500)
	{
		LED_ON;
	}
	else 
	{
		LED_OFF;
	}
	HAL_Delay(40);
}
//--------------------------------------------
void AccInit(void)
{


	uint8_t value = 0;
	//
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL3_C);
	value&=~LSM6DS3_ACC_GYRO_IF_INC_MASK;
	value|=LSM6DS3_ACC_GYRO_IF_INC_ENABLED;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL3_C,value);
	//  BDU
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL3_C);
	value&=~LSM6DS3_ACC_GYRO_BDU_MASK;
	value|=LSM6DS3_ACC_GYRO_BDU_BLOCK_UPDATE;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL3_C,value);
	//  FIFO
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_FIFO_CTRL5);
	value&=~LSM6DS3_ACC_GYRO_FIFO_MODE_MASK;
	value|=LSM6DS3_ACC_GYRO_FIFO_MODE_BYPASS;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_FIFO_CTRL5,value);
	//   (ODR_XL = 0000)
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL1_XL);
	value&=~LSM6DS3_ACC_GYRO_ODR_XL_MASK;
	value|=LSM6DS3_ACC_GYRO_ODR_XL_POWER_DOWN;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL1_XL,value);
	//Full scale selection 2G
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL1_XL);
	value&=~LSM6DS3_ACC_GYRO_FS_XL_MASK;
	value|=LSM6DS3_ACC_GYRO_FS_XL_2g;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL1_XL,value);
	// 
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL9_XL);
	value&=~(LSM6DS3_ACC_GYRO_XEN_XL_MASK|\
					 LSM6DS3_ACC_GYRO_YEN_XL_MASK|\
					 LSM6DS3_ACC_GYRO_ZEN_XL_MASK);
	value|=(LSM6DS3_ACC_GYRO_XEN_XL_ENABLED|\
					LSM6DS3_ACC_GYRO_YEN_XL_ENABLED|\
					LSM6DS3_ACC_GYRO_ZEN_XL_ENABLED);
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL9_XL,value);
	// Data Rate 119 
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL1_XL);
	value&=~LSM6DS3_ACC_GYRO_ODR_XL_MASK;
	value|=LSM6DS3_ACC_GYRO_ODR_XL_104Hz;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL1_XL,value);	
}
//--------------------------------------------
void GyroInit(void)
{
	uint8_t value = 0;
	//
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL3_C);
	value&=~LSM6DS3_ACC_GYRO_IF_INC_MASK;
	value|=LSM6DS3_ACC_GYRO_IF_INC_ENABLED;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL3_C,value);
	//  BDU
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL3_C);
	value&=~LSM6DS3_ACC_GYRO_BDU_MASK;
	value|=LSM6DS3_ACC_GYRO_BDU_BLOCK_UPDATE;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL3_C,value);
	//  FIFO
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_FIFO_CTRL5);
	value&=~LSM6DS3_ACC_GYRO_FIFO_MODE_MASK;
	value|=LSM6DS3_ACC_GYRO_FIFO_MODE_BYPASS;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_FIFO_CTRL5,value);
	//   (ODR_G = 0000)
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL2_G);
	value&=~LSM6DS3_ACC_GYRO_ODR_G_MASK;
	value|=LSM6DS3_ACC_GYRO_ODR_G_POWER_DOWN;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL2_G,value);
	//Full scale selection 500 dps
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL2_G);
	value&=~LSM6DS3_ACC_GYRO_FS_G_500dps;
	value|=LSM6DS3_ACC_GYRO_FS_XL_2g;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL2_G,value);
	// 
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL10_C);
	value&=~(LSM6DS3_ACC_GYRO_XEN_G_MASK|\
					 LSM6DS3_ACC_GYRO_YEN_G_MASK|\
					 LSM6DS3_ACC_GYRO_ZEN_G_MASK);
	value|=(LSM6DS3_ACC_GYRO_XEN_G_ENABLED|\
					LSM6DS3_ACC_GYRO_YEN_G_ENABLED|\
					LSM6DS3_ACC_GYRO_ZEN_G_ENABLED);
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL10_C,value);
	// Data Rate 833 
	value = Accel_IO_Read(LSM6DS3_ACC_GYRO_CTRL2_G);
	value&=~LSM6DS3_ACC_GYRO_ODR_G_833Hz;
	value|=LSM6DS3_ACC_GYRO_ODR_XL_104Hz;
	Accel_IO_Write(LSM6DS3_ACC_GYRO_CTRL2_G,value);	
}
//--------------------------------------------
void Accel_Gyro_Ini(void)
{
	HAL_Delay(1000);
	if(Accel_ReadID()==0x69) LED_ON;
	else Error();
	LED_OFF;
	AccInit();
	GyroInit();
	LED_ON;
}

/*************************************/	
void SPI2_write(uint8_t addr, uint8_t data)
{
		uint16_t tmp=0;//unsigned int tmp;
		tmp=addr&127;
		tmp=(tmp<<8);
		tmp=(tmp|data);
	
		HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, GPIO_PIN_RESET);//    NSS = 0 
		HAL_SPI_Transmit(&hspi2,(uint8_t*)&tmp, 1, 1000);//    
		HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, GPIO_PIN_SET);//    NSS = 1
}
/*************************************/
uint8_t SPI2_read(uint8_t addr)
{
	uint16_t tmp=0;//unsigned int tmp;
	tmp=addr|128;
	tmp=tmp<<8;
	
	HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, GPIO_PIN_RESET);//    NSS = 0 	
	HAL_SPI_Transmit(&hspi2,(uint8_t*)&tmp, 1, 1000);//    	
	HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, GPIO_PIN_SET);//    NSS = 1
	tmp=SPI2_DATA;
	return ((uint8_t)tmp);
}
